/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DefaultGridTransferHandler
implements GridTransferHandler<AbstractContainerMenu> {
    @Override
    public ItemStack putIntoGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, int slotId, ItemStack itemStack) {
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return itemStack;
        }
        ItemStack craftStack = craftMatrix.m_8020_(slotId);
        if (!craftStack.m_41619_()) {
            int spaceLeft;
            if (craftStack.m_41656_(itemStack) && ItemStack.m_41658_((ItemStack)craftStack, (ItemStack)itemStack) && (spaceLeft = Math.min(craftMatrix.m_6893_(), craftStack.m_41741_()) - craftStack.m_41613_()) > 0) {
                ItemStack splitStack = itemStack.m_41620_(Math.min(spaceLeft, itemStack.m_41613_()));
                craftStack.m_41769_(splitStack.m_41613_());
                if (itemStack.m_41613_() <= 0) {
                    return ItemStack.f_41583_;
                }
            }
        } else {
            ItemStack transferStack = itemStack.m_41620_(Math.min(itemStack.m_41613_(), craftMatrix.m_6893_()));
            craftMatrix.m_6836_(slotId, transferStack);
        }
        if (itemStack.m_41613_() <= 0) {
            return ItemStack.f_41583_;
        }
        return itemStack;
    }

    @Override
    public boolean transferIntoGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, Slot fromSlot) {
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return false;
        }
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        ItemStack itemStack = fromSlot.m_7993_();
        if (itemStack.m_41619_()) {
            return false;
        }
        int firstEmptySlot = -1;
        for (int i = start; i < start + size; ++i) {
            int slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
            ItemStack craftStack = craftMatrix.m_8020_(slotIndex);
            if (!craftStack.m_41619_()) {
                int spaceLeft;
                if (!craftStack.m_41656_(itemStack) || !ItemStack.m_41658_((ItemStack)craftStack, (ItemStack)itemStack) || (spaceLeft = Math.min(craftMatrix.m_6893_(), craftStack.m_41741_()) - craftStack.m_41613_()) <= 0) continue;
                ItemStack splitStack = itemStack.m_41620_(Math.min(spaceLeft, itemStack.m_41613_()));
                craftStack.m_41769_(splitStack.m_41613_());
                if (itemStack.m_41613_() > 0) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = slotIndex;
        }
        if (itemStack.m_41613_() > 0 && firstEmptySlot != -1) {
            ItemStack transferStack = itemStack.m_41620_(Math.min(itemStack.m_41613_(), craftMatrix.m_6893_()));
            craftMatrix.m_6836_(firstEmptySlot, transferStack);
            return true;
        }
        return false;
    }

    @Override
    public boolean canTransferFrom(Player player, AbstractContainerMenu menu, Slot slot, CraftingGrid toGrid) {
        return slot.f_40218_ == player.m_150109_();
    }
}

